<?php
/**
 * Displays footer widgets if assigned
 *
 * @package Gym Club
 * @subpackage gym_club
 */

?>
<?php

// Determine the number of columns dynamically for the footer (you can replace this with your logic).
$gym_club_number_of_footer_columns = get_theme_mod('gym_club_footer_columns', 4); // Change this value as needed.

// Calculate the Bootstrap class for large screens (col-lg-X) for footer.
$gym_club_col_lg_footer_class = 'col-lg-' . (12 / $gym_club_number_of_footer_columns);

// Calculate the Bootstrap class for medium screens (col-md-X) for footer.
$gym_club_col_md_footer_class = 'col-md-' . (12 / $gym_club_number_of_footer_columns);
?>
<div class="container">
    <aside class="widget-area row py-2 pt-3" role="complementary" aria-label="<?php esc_attr_e( 'Footer', 'gym-club' ); ?>">
        <?php
        $gym_club_default_widgets = array(
            1 => 'search',
            2 => 'archives',
            3 => 'meta',
            4 => 'categories'
        );

        for ($gym_club_i = 1; $gym_club_i <= $gym_club_no_of_footer_col; $gym_club_i++) :
            $gym_club_lg_class = esc_attr($gym_club_col_lg_footer_class);
            $gym_club_md_class = esc_attr($gym_club_col_md_footer_class);
            echo '<div class="col-12 ' . $gym_club_lg_class . ' ' . $gym_club_md_class . '">';

            if (is_active_sidebar('footer-' . $gym_club_i)) {
                dynamic_sidebar('footer-' . $gym_club_i);
            } else {
                // Display default widget content if not active.
                switch ($gym_club_default_widgets[$gym_club_i] ?? '') {
                    case 'search':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Search', 'gym-club'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Search', 'gym-club'); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                        <?php
                        break;

                    case 'archives':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Archives', 'gym-club'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Archives', 'gym-club'); ?></h3>
                            <ul><?php wp_get_archives(['type' => 'monthly']); ?></ul>
                        </aside>
                        <?php
                        break;

                    case 'meta':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Meta', 'gym-club'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Meta', 'gym-club'); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                        <?php
                        break;

                    case 'categories':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Categories', 'gym-club'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Categories', 'gym-club'); ?></h3>
                            <ul><?php wp_list_categories(['title_li' => '']); ?></ul>
                        </aside>
                        <?php
                        break;
                }
            }

            echo '</div>';
        endfor;
        ?>
    </aside>
</div>