<?php 
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {

    // ------- Create Nav Menu --------
$gym_club_menuname = 'Main Menus';
$gym_club_bpmenulocation = 'primary-menu';
$gym_club_menu_exists = wp_get_nav_menu_object($gym_club_menuname);

if (!$gym_club_menu_exists) {
    $gym_club_menu_id = wp_create_nav_menu($gym_club_menuname);

    // Create Home Page
    $gym_club_home_title = 'Home';
    $gym_club_home = array(
        'post_type' => 'page',
        'post_title' => $gym_club_home_title,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $gym_club_home_id = wp_insert_post($gym_club_home);

    // Assign Home Page Template
    add_post_meta($gym_club_home_id, '_wp_page_template', 'page-template/front-page.php');

    // Update options to set Home Page as the front page
    update_option('page_on_front', $gym_club_home_id);
    update_option('show_on_front', 'page');

    // Add Home Page to Menu
    wp_update_nav_menu_item($gym_club_menu_id, 0, array(
        'menu-item-title' => __('Home', 'gym-club'),
        'menu-item-classes' => 'home',
        'menu-item-url' => home_url('/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $gym_club_home_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create About Us Page with Dummy Content
    $gym_club_about_title = 'About Us';
    $gym_club_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $gym_club_about = array(
        'post_type' => 'page',
        'post_title' => $gym_club_about_title,
        'post_content' => $gym_club_about_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'about-us'
    );
    $gym_club_about_id = wp_insert_post($gym_club_about);

    // Add About Us Page to Menu
    wp_update_nav_menu_item($gym_club_menu_id, 0, array(
        'menu-item-title' => __('About Us', 'gym-club'),
        'menu-item-classes' => 'about-us',
        'menu-item-url' => home_url('/about-us/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $gym_club_about_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Services Page with Dummy Content
    $gym_club_services_title = 'Services';
    $gym_club_services_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $gym_club_services = array(
        'post_type' => 'page',
        'post_title' => $gym_club_services_title,
        'post_content' => $gym_club_services_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'services'
    );
    $gym_club_services_id = wp_insert_post($gym_club_services);

    // Add Services Page to Menu
    wp_update_nav_menu_item($gym_club_menu_id, 0, array(
        'menu-item-title' => __('Services', 'gym-club'),
        'menu-item-classes' => 'services',
        'menu-item-url' => home_url('/services/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $gym_club_services_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Pages Page with Dummy Content
    $gym_club_pages_title = 'Pages';
    $gym_club_pages_content = '<h2>Our Pages</h2>
    <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>';
    $gym_club_pages = array(
        'post_type' => 'page',
        'post_title' => $gym_club_pages_title,
        'post_content' => $gym_club_pages_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'pages'
    );
    $gym_club_pages_id = wp_insert_post($gym_club_pages);

    // Add Pages Page to Menu
    wp_update_nav_menu_item($gym_club_menu_id, 0, array(
        'menu-item-title' => __('Pages', 'gym-club'),
        'menu-item-classes' => 'pages',
        'menu-item-url' => home_url('/pages/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $gym_club_pages_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Contact Page with Dummy Content
    $gym_club_contact_title = 'Contact';
    $gym_club_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $gym_club_contact = array(
        'post_type' => 'page',
        'post_title' => $gym_club_contact_title,
        'post_content' => $gym_club_contact_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $gym_club_contact_id = wp_insert_post($gym_club_contact);

    // Add Contact Page to Menu
    wp_update_nav_menu_item($gym_club_menu_id, 0, array(
        'menu-item-title' => __('Contact', 'gym-club'),
        'menu-item-classes' => 'contact',
        'menu-item-url' => home_url('/contact/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $gym_club_contact_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Set the menu location if it's not already set
    if (!has_nav_menu($gym_club_bpmenulocation)) {
        $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
        if (empty($locations)) {
            $locations = array();
        }
        $locations[$gym_club_bpmenulocation] = $gym_club_menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }
}

        //---Header--//
        set_theme_mod('gym_club_location', 'Sydney, Australia');
        set_theme_mod('gym_club_call', '+614 434 333');
        set_theme_mod('gym_club_mail', 'info@fithub.com');
        set_theme_mod('gym_club_header_button', 'GET STARTED FOR FREE');
        set_theme_mod('gym_club_header_link', '#');


        set_theme_mod('gym_club_header_ins_new_tab', true);
        set_theme_mod('gym_club_instagram_url', '#');
        set_theme_mod('gym_club_instagram_icon', 'fab fa-instagram');

        set_theme_mod('gym_club_linkedin_new_tab', true);
        set_theme_mod('gym_club_linkedin_url', '#');
        set_theme_mod('gym_club_linkedin_icon', 'fab fa-linkedin');

        set_theme_mod('gym_club_header_twt_new_tab', true);
        set_theme_mod('gym_club_twitter_url', '#');
        set_theme_mod('gym_club_twitter_icon', 'fab fa-twitter');

        set_theme_mod('gym_club_header_ut_new_tab', true);
        set_theme_mod('gym_club_youtube_url', '#');
        set_theme_mod('gym_club_youtube_icon', 'fab fa-youtube');

        // Slider Section
        set_theme_mod('gym_club_slider_arrows', true);
        set_theme_mod('gym_club_slider_short_heading', 'BODY');
        set_theme_mod('gym_club_slider_play_url', '#');
        set_theme_mod('gym_club_btn_text1', 'JOIN FREE 3 DAYS TRIAL');
        set_theme_mod('gym_club_btn_link1', '#');

        for ($i = 1; $i <= 4; $i++) {
            $gym_club_title = 'MAKE YOUR';
            $gym_club_content = 'Gyms are adaptable to various fitness levels and preferences, catering ';

            // Create post object
            $my_post = array(
                'post_title'    => wp_strip_all_tags($gym_club_title),
                'post_content'  => $gym_club_content,
                'post_status'   => 'publish',
                'post_type'     => 'page',
            );

            /// Insert the post into the database
            $post_id = wp_insert_post($my_post);

            if ($post_id) {
                // Set the theme mod for the slider page
                set_theme_mod('gym_club_slider_page' . $i, $post_id);

                $image_url = get_template_directory_uri() . '/assets/images/header_img.png';
                $image_id = media_sideload_image($image_url, $post_id, null, 'id');

                if (!is_wp_error($image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($post_id, $image_id);
                }
            }
        }

        // Our Services Section //
    set_theme_mod('gym_club_offer_section_tittle', 'Our Services');
    set_theme_mod('gym_club_offer_section_text', 'Our Service For You');

    set_theme_mod('gym_club_offer_section_category', 'postcategory1');

    // Define post category names and post titles
    $gym_club_category_names = array('postcategory1');
    $gym_club_title_array = array(
        array("Weight Lifting", "Body Balance", "Beginner Pilates", "Cardio Strength")
    );

    foreach ($gym_club_category_names as $gym_club_index => $gym_club_category_name) {
        // Create or retrieve the post category term ID
        $gym_club_term = term_exists($gym_club_category_name, 'category');
        if ($gym_club_term === 0 || $gym_club_term === null) {
            // If the term does not exist, create it
            $gym_club_term = wp_insert_term($gym_club_category_name, 'category');
        }
        if (is_wp_error($gym_club_term)) {
            error_log('Error creating category: ' . $gym_club_term->get_error_message());
            continue; // Skip to the next iteration if category creation fails
        }

        for ($gym_club_i = 0; $gym_club_i < 4; $gym_club_i++) {
            // Create post content
            $gym_club_title = $gym_club_title_array[$gym_club_index][$gym_club_i];

            // Create post post object
            $gym_club_my_post = array(
                'post_title'    => wp_strip_all_tags($gym_club_title),
                'post_status'   => 'publish',
                'post_type'     => 'post', // Post type set to 'post'
            );

            // Insert the post into the database
            $gym_club_post_id = wp_insert_post($gym_club_my_post);

            if (is_wp_error($gym_club_post_id)) {
                error_log('Error creating post: ' . $gym_club_post_id->get_error_message());
                continue; // Skip to the next post if creation fails
            }

            // Assign the category to the post
            wp_set_post_categories($gym_club_post_id, array((int)$gym_club_term['term_id']));

            // Handle the featured image using media_sideload_image
            $gym_club_image_url = get_template_directory_uri() . '/assets/images/post-img.png';
            $gym_club_image_id = media_sideload_image($gym_club_image_url, $gym_club_post_id, null, 'id');

            if (is_wp_error($gym_club_image_id)) {
                error_log('Error downloading image: ' . $gym_club_image_id->get_error_message());
                continue; // Skip to the next post if image download fails
            }

            // Assign featured image to post
            set_post_thumbnail($gym_club_post_id, $gym_club_image_id);
        }
    }



    }
?>