<?php
/**
 * Gym Club: Customizer
 *
 * @package Gym Club
 * @subpackage gym_club
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function gym_club_customize_register( $wp_customize ) {

	require get_parent_theme_file_path('/inc/controls/icon-changer.php');

	require get_parent_theme_file_path('/inc/controls/range-slider-control.php');

	// Register the custom control type.
	$wp_customize->register_control_type( 'Gym_Club_Toggle_Control' );

	//Register the sortable control type.
	$wp_customize->register_control_type( 'Gym_Club_Control_Sortable' );	

	//add home page setting pannel
	$wp_customize->add_panel( 'gym_club_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Custom Home page', 'gym-club' ),
	    'description' => __( 'Description of what this panel does.', 'gym-club' ),
	) );

	//TP Genral Option
	$wp_customize->add_section('gym_club_tp_general_settings',array(
        'title' => __('TP General Option', 'gym-club'),
        'priority' => 1,
        'panel' => 'gym_club_panel_id'
    ) );
 	$wp_customize->add_setting('gym_club_tp_body_layout_settings',array(
		'default' => 'Full',
		'sanitize_callback' => 'gym_club_sanitize_choices'
	));

 	$wp_customize->add_control('gym_club_tp_body_layout_settings',array(
		'type' => 'radio',
		'label'     => __('Body Layout Setting', 'gym-club'),
		'description'   => __('This option work for complete body, if you want to set the complete website in container.', 'gym-club'),
		'section' => 'gym_club_tp_general_settings',
		'choices' => array(
		'Full' => __('Full','gym-club'),
		'Container' => __('Container','gym-club'),
		'Container Fluid' => __('Container Fluid','gym-club')
		),
	) );

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('gym_club_sidebar_post_layout',array(
     'default' => 'right',
     'sanitize_callback' => 'gym_club_sanitize_choices'
	));
	$wp_customize->add_control('gym_club_sidebar_post_layout',array(
     'type' => 'radio',
     'label'     => __('Post Sidebar Position', 'gym-club'),
     'description'   => __('This option work for blog page, blog single page, archive page and search page.', 'gym-club'),
     'section' => 'gym_club_tp_general_settings',
     'choices' => array(
         'full' => __('Full','gym-club'),
         'left' => __('Left','gym-club'),
         'right' => __('Right','gym-club'),
         'three-column' => __('Three Columns','gym-club'),
         'four-column' => __('Four Columns','gym-club'),
         'grid' => __('Grid Layout','gym-club')
     ),
	) );

	// Add Settings and Controls for single post sidebar Layout
	$wp_customize->add_setting('gym_club_sidebar_single_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'gym_club_sanitize_choices'
	));
	$wp_customize->add_control('gym_club_sidebar_single_post_layout',array(
        'type' => 'radio',
        'label'     => __('Single Post Sidebar Position', 'gym-club'),
        'description'   => __('This option work for single blog page', 'gym-club'),
        'section' => 'gym_club_tp_general_settings',
        'choices' => array(
            'full' => __('Full','gym-club'),
            'left' => __('Left','gym-club'),
            'right' => __('Right','gym-club'),
        ),
	) );

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('gym_club_sidebar_page_layout',array(
     'default' => 'right',
     'sanitize_callback' => 'gym_club_sanitize_choices'
	));
	$wp_customize->add_control('gym_club_sidebar_page_layout',array(
     'type' => 'radio',
     'label'     => __('Page Sidebar Position', 'gym-club'),
     'description'   => __('This option work for pages.', 'gym-club'),
     'section' => 'gym_club_tp_general_settings',
     'choices' => array(
         'full' => __('Full','gym-club'),
         'left' => __('Left','gym-club'),
         'right' => __('Right','gym-club')
     ),
	) );
	//tp typography option
	$gym_club_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Agdasima'               => 'Agdasima',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	$wp_customize->add_section('gym_club_typography_option',array(
		'title'         => __('TP Typography Option', 'gym-club'),
		'priority' => 1,
		'panel' => 'gym_club_panel_id'
   	));

   	$wp_customize->add_setting('gym_club_heading_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_club_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_club_heading_font_family', array(
		'section' => 'gym_club_typography_option',
		'label'   => __('heading Fonts', 'gym-club'),
		'type'    => 'select',
		'choices' => $gym_club_font_array,
	));

	$wp_customize->add_setting('gym_club_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_club_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_club_body_font_family', array(
		'section' => 'gym_club_typography_option',
		'label'   => __('Body Fonts', 'gym-club'),
		'type'    => 'select',
		'choices' => $gym_club_font_array,
	));
	
	//TP Preloader Option
	$wp_customize->add_section('gym_club_prelaoder_option',array(
		'title'         => __('TP Preloader Option', 'gym-club'),
		'priority' => 1,
		'panel' => 'gym_club_panel_id'
	) );

	$wp_customize->add_setting( 'gym_club_preloader_show_hide', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_preloader_show_hide', array(
		'label'       => esc_html__( 'Show / Hide Preloader Option', 'gym-club' ),
		'section'     => 'gym_club_prelaoder_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_preloader_show_hide',
	) ) );

	$wp_customize->add_setting( 'gym_club_tp_preloader_color1_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_preloader_color1_option', array(
			'label'     => __('Preloader First Ring Color', 'gym-club'),
	    'description' => __('It will change the complete theme preloader ring 1 color in one click.', 'gym-club'),
	    'section' => 'gym_club_prelaoder_option',
	    'settings' => 'gym_club_tp_preloader_color1_option',
  	)));

  	$wp_customize->add_setting( 'gym_club_tp_preloader_color2_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_preloader_color2_option', array(
			'label'     => __('Preloader Second Ring Color', 'gym-club'),
	    'description' => __('It will change the complete theme preloader ring 2 color in one click.', 'gym-club'),
	    'section' => 'gym_club_prelaoder_option',
	    'settings' => 'gym_club_tp_preloader_color2_option',
  	)));

  	$wp_customize->add_setting( 'gym_club_tp_preloader_bg_color_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_preloader_bg_color_option', array(
			'label'     => __('Preloader Background Color', 'gym-club'),
	    'description' => __('It will change the complete theme preloader bg color in one click.', 'gym-club'),
	    'section' => 'gym_club_prelaoder_option',
	    'settings' => 'gym_club_tp_preloader_bg_color_option',
  	)));

  	//TP Color Option
	$wp_customize->add_section('gym_club_color_option',array(
     'title'         => __('TP Color Option', 'gym-club'),
     'priority' => 1,
     'panel' => 'gym_club_panel_id'
    ) );
    
	$wp_customize->add_setting( 'gym_club_tp_color_option', array(
	    'default' => '#B5EA00',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_color_option', array(
			'label'     => __('Theme First Color', 'gym-club'),
	    'description' => __('It will change the complete theme color in one click.', 'gym-club'),
	    'section' => 'gym_club_color_option',
	    'settings' => 'gym_club_tp_color_option',
  	)));
  	
  	$wp_customize->add_setting( 'gym_club_tp_color_option_link', array(
	    'default' => '#C5FF00',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_color_option_link', array(
			'label'     => __('Theme Second Color', 'gym-club'),
	    'description' => __('It will change the complete theme color in one click.', 'gym-club'),
	    'section' => 'gym_club_color_option',
	    'settings' => 'gym_club_tp_color_option_link',
  	)));

  	$wp_customize->add_setting( 'gym_club_tp_color_option_third', array(
	    'default' => '#88AF00',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_color_option_third', array(
			'label'     => __('Theme Third Color', 'gym-club'),
	    'description' => __('It will change the complete theme color in one click.', 'gym-club'),
	    'section' => 'gym_club_color_option',
	    'settings' => 'gym_club_tp_color_option_third',
  	)));

	//TP Blog Option
	$wp_customize->add_section('gym_club_blog_option',array(
		'title' => __('TP Blog Option', 'gym-club'),
		'priority' => 1,
		'panel' => 'gym_club_panel_id'
	) );

	$wp_customize->add_setting('gym_club_edit_blog_page_title',array(
		'default'=> __('Home','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_edit_blog_page_title',array(
		'label'	=> __('Change Blog Page Title','gym-club'),
		'section'=> 'gym_club_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_club_edit_blog_page_description',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_edit_blog_page_description',array(
		'label'	=> __('Add Blog Description','gym-club'),
		'section'=> 'gym_club_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('blog_meta_order', array(
        'default' => array('date', 'author', 'comment', 'category'),
        'sanitize_callback' => 'gym_club_sanitize_sortable',
    ));
    $wp_customize->add_control(new Gym_Club_Control_Sortable($wp_customize, 'blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'gym-club'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'gym-club') ,
        'section' => 'gym_club_blog_option',
        'choices' => array(
            'date' => __('date', 'gym-club') ,
            'author' => __('author', 'gym-club') ,
            'comment' => __('comment', 'gym-club') ,
            'category' => __('category', 'gym-club') ,
        ) ,
    )));

    $wp_customize->add_setting( 'gym_club_excerpt_count', array(
		'default'              => 35,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'gym_club_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'gym_club_excerpt_count', array(
		'label'       => esc_html__( 'Edit Excerpt Limit','gym-club' ),
		'section'     => 'gym_club_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('gym_club_post_image_round', array(
	  'default' => '0',
      'sanitize_callback' => 'gym_club_sanitize_number_range',
	));
	$wp_customize->add_control(new Gym_Club_Range_Slider($wp_customize, 'gym_club_post_image_round', array(
       'section' => 'gym_club_blog_option',
      'label' => esc_html__('Edit Post Image Border Radius', 'gym-club'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 180,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('gym_club_post_image_width', array(
	  'default' => '',
      'sanitize_callback' => 'gym_club_sanitize_number_range',
	));
	$wp_customize->add_control(new Gym_Club_Range_Slider($wp_customize, 'gym_club_post_image_width', array(
       'section' => 'gym_club_blog_option',
      'label' => esc_html__('Edit Post Image Width', 'gym-club'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 367,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('gym_club_post_image_length', array(
	  'default' => '',
      'sanitize_callback' => 'gym_club_sanitize_number_range',
	));
	$wp_customize->add_control(new Gym_Club_Range_Slider($wp_customize, 'gym_club_post_image_length', array(
       'section' => 'gym_club_blog_option',
      'label' => esc_html__('Edit Post Image height', 'gym-club'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 900,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('gym_club_read_more_text',array(
		'default'=> __('Read More','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_read_more_text',array(
		'label'	=> __('Edit Button Text','gym-club'),
		'section'=> 'gym_club_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'gym_club_remove_read_button', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_remove_read_button', array(
		'label'       => esc_html__( 'Show / Hide Read More Button', 'gym-club' ),
		'section'     => 'gym_club_blog_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_remove_read_button',
	) ) );

	 $wp_customize->add_setting( 'gym_club_remove_tags', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_remove_tags', array(
		'label'       => esc_html__( 'Show / Hide Tags Option', 'gym-club' ),
		'section'     => 'gym_club_blog_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_remove_tags',
	) ) );

	$wp_customize->add_setting( 'gym_club_remove_category', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_remove_category', array(
		'label'       => esc_html__( 'Show / Hide Category Option', 'gym-club' ),
		'section'     => 'gym_club_blog_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_remove_category',
	) ) );

	$wp_customize->add_setting( 'gym_club_remove_comment', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'gym_club_sanitize_checkbox',
 	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_remove_comment', array(
	 'label'       => esc_html__( 'Show / Hide Comment Form', 'gym-club' ),
	 'section'     => 'gym_club_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'gym_club_remove_comment',
	) ) );

	$wp_customize->add_setting( 'gym_club_remove_related_post', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'gym_club_sanitize_checkbox',
 	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_remove_related_post', array(
	 'label'       => esc_html__( 'Show / Hide Related Post', 'gym-club' ),
	 'section'     => 'gym_club_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'gym_club_remove_related_post',
	) ) );

	$wp_customize->add_setting( 'gym_club_related_post_per_page', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'gym_club_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'gym_club_related_post_per_page', array(
		'label'       => esc_html__( 'Related Post Per Page','gym-club' ),
		'section'     => 'gym_club_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 3,
			'max'              => 9,
		),
	) );

	 //MENU TYPOGRAPHY
	$wp_customize->add_section( 'gym_club_menu_typography', array(
    	'title'      => __( 'Menu Typography', 'gym-club' ),
    	'priority' => 2,
		'panel' => 'gym_club_panel_id'
	) );
	
	$wp_customize->add_setting('gym_club_menu_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'gym_club_sanitize_choices',
	));
	$wp_customize->add_control(	'gym_club_menu_font_family', array(
		'section' => 'gym_club_menu_typography',
		'label'   => __('Menu Fonts', 'gym-club'),
		'type'    => 'select',
		'choices' => $gym_club_font_array,
	));

	$wp_customize->add_setting('gym_club_menu_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'gym_club_sanitize_choices'
 	));
 	$wp_customize->add_control('gym_club_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','gym-club'),
		'section' => 'gym_club_menu_typography',
		'choices' => array(
		   'Uppercase' => __('Uppercase','gym-club'),
		   'Lowercase' => __('Lowercase','gym-club'),
		   'Capitalize' => __('Capitalize','gym-club'),
		),
	) );
	
	$wp_customize->add_setting('gym_club_menu_font_size', array(
	  'default' => '',
      'sanitize_callback' => 'gym_club_sanitize_number_range',
	));
	$wp_customize->add_control(new Gym_Club_Range_Slider($wp_customize, 'gym_club_menu_font_size', array(
       'section' => 'gym_club_menu_typography',
      'label' => esc_html__('Font Size', 'gym-club'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 20,
        'step' => 1
    )
	)));

	$wp_customize->add_setting( 'gym_club_menu_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_menu_color', array(
			'label'     => __('Change Menu Color', 'gym-club'),
	    'section' => 'gym_club_menu_typography',
	    'settings' => 'gym_club_menu_color',
  	)));

	// Top bar Section
	$wp_customize->add_section( 'gym_club_topbar', array(
    	'title'      => __( 'Contact Details', 'gym-club' ),
    	'description' => __( 'Add your contact details', 'gym-club' ),
		'panel' => 'gym_club_panel_id',
      'priority' => 2,
	) );

	$wp_customize->add_setting('gym_club_topbar_visibility', array(
	    'default'           => true, // Default is to show the top bar.
	    'transport'         => 'refresh',
	    'sanitize_callback' => 'gym_club_sanitize_checkbox',
	));
	$wp_customize->add_control(new Gym_Club_Toggle_Control($wp_customize, 'gym_club_topbar_visibility', array(
	    'label'       => esc_html__('Show / Hide Topbar', 'gym-club'),
	    'section'     => 'gym_club_topbar',
	    'type'        => 'toggle',
	    'settings'    => 'gym_club_topbar_visibility',
	)));

	$wp_customize->add_setting('gym_club_location',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_location',array(
		'label'	=> __('Add location','gym-club'),
		'section'=> 'gym_club_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_club_call',array(
		'default'=> '',
		'sanitize_callback'	=> 'gym_club_sanitize_phone_number'
	));
	$wp_customize->add_control('gym_club_call',array(
		'label'	=> __('Add Phone Number','gym-club'),
		'section'=> 'gym_club_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_club_mail',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('gym_club_mail',array(
		'label'	=> __('Add Mail Address','gym-club'),
		'section'=> 'gym_club_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_club_header_button',array(
		'default'=> __('GET STARTED FOR FREE','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_header_button',array(
		'label'	=> __('Header Button Text','gym-club'),
		'section'=> 'gym_club_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_club_header_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_club_header_link',array(
		'label'	=> __('Header Button Link','gym-club'),
		'section'=> 'gym_club_topbar',
		'type'=> 'url'
	));

	// Social Link
	$wp_customize->add_section( 'gym_club_social_media', array(
    	'title'      => __( 'Social Media Links', 'gym-club' ),
    	'description' => __( 'Add your Social Links', 'gym-club' ),
		'panel' => 'gym_club_panel_id',
      'priority' => 2,
	) );
	
	$wp_customize->add_setting( 'gym_club_header_ins_new_tab', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_header_ins_new_tab', array(
		'label'       => esc_html__( 'Open in new tab', 'gym-club' ),
		'section'     => 'gym_club_social_media',
		'type'        => 'toggle',
		'settings'    => 'gym_club_header_ins_new_tab',
	) ) );

	$wp_customize->add_setting('gym_club_instagram_url',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_club_instagram_url',array(
		'label'	=> __('Instagram Link','gym-club'),
		'section'=> 'gym_club_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('gym_club_instagram_icon',array(
		'default'	=> 'fab fa-instagram',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Club_Icon_Changer(
        $wp_customize,'gym_club_instagram_icon',array(
		'label'	=> __('Instagram Icon','gym-club'),
		'transport' => 'refresh',
		'section'	=> 'gym_club_social_media',
		'type'		=> 'icon'
	)));
	
	$wp_customize->add_setting( 'gym_club_linkedin_new_tab', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_linkedin_new_tab', array(
		'label'       => esc_html__( 'Open in new tab', 'gym-club' ),
		'section'     => 'gym_club_social_media',
		'type'        => 'toggle',
		'settings'    => 'gym_club_linkedin_new_tab',
	) ) );

	$wp_customize->add_setting('gym_club_linkedin_url',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_club_linkedin_url',array(
		'label'	=> __('Linkedin Link','gym-club'),
		'section'=> 'gym_club_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('gym_club_linkedin_icon',array(
		'default'	=> 'fab fa-linkedin',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Club_Icon_Changer(
        $wp_customize,'gym_club_linkedin_icon',array(
		'label'	=> __('Linkedin Icon','gym-club'),
		'transport' => 'refresh',
		'section'	=> 'gym_club_social_media',
		'type'		=> 'icon'
	)));

	
	$wp_customize->add_setting( 'gym_club_header_twt_new_tab', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_header_twt_new_tab', array(
		'label'       => esc_html__( 'Open in new tab', 'gym-club' ),
		'section'     => 'gym_club_social_media',
		'type'        => 'toggle',
		'settings'    => 'gym_club_header_twt_new_tab',
	) ) );

	$wp_customize->add_setting('gym_club_twitter_url',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_club_twitter_url',array(
		'label'	=> __('Twitter Link','gym-club'),
		'section'=> 'gym_club_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('gym_club_twitter_icon',array(
		'default'	=> 'fab fa-twitter',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Club_Icon_Changer(
        $wp_customize,'gym_club_twitter_icon',array(
		'label'	=> __('Twitter Icon','gym-club'),
		'transport' => 'refresh',
		'section'	=> 'gym_club_social_media',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'gym_club_youtube_new_tab', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_youtube_new_tab', array(
		'label'       => esc_html__( 'Open in new tab', 'gym-club' ),
		'section'     => 'gym_club_social_media',
		'type'        => 'toggle',
		'settings'    => 'gym_club_youtube_new_tab',
	) ) );

	$wp_customize->add_setting('gym_club_youtube_url',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_club_youtube_url',array(
		'label'	=> __('Youtube Link','gym-club'),
		'section'=> 'gym_club_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('gym_club_youtube_icon',array(
		'default'	=> 'fab fa-youtube',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Club_Icon_Changer(
        $wp_customize,'gym_club_youtube_icon',array(
		'label'	=> __('Youtube Icon','gym-club'),
		'transport' => 'refresh',
		'section'	=> 'gym_club_social_media',
		'type'		=> 'icon'
	)));

	//home page slider
	$wp_customize->add_section( 'gym_club_slider_section' , array(
    	'title'      => __( 'Slider Settings', 'gym-club' ),
		'panel' => 'gym_club_panel_id',
      'priority' => 6,
	) );

	$wp_customize->add_setting( 'gym_club_slider_arrows', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_slider_arrows', array(
		'label'       => esc_html__( 'Show / Hide slider', 'gym-club' ),
		'section'     => 'gym_club_slider_section',
		'type'        => 'toggle',
		'settings'    => 'gym_club_slider_arrows',
	) ) );

	for ( $gym_club_count = 1; $gym_club_count <= 4; $gym_club_count++ ) {

		// Add color scheme setting and control.
		$wp_customize->add_setting( 'gym_club_slider_page' . $gym_club_count, array(
			'default'           => '',
			'sanitize_callback' => 'gym_club_sanitize_dropdown_pages'
		) );

		$wp_customize->add_control( 'gym_club_slider_page' . $gym_club_count, array(
			'label'    => __( 'Select Slide Image Page', 'gym-club' ),
			'section'  => 'gym_club_slider_section',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('gym_club_slider_short_heading',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_slider_short_heading',array(
		'label'	=> __('Add Highlight Text','gym-club'),
		'section'=> 'gym_club_slider_section',
		'type'=> 'text'
	));

	// YouTube URL
	$wp_customize->add_setting(
	    'gym_club_slider_play_url',
	    array(
	        'default'           => '',
	        'sanitize_callback' => 'esc_url_raw',
	    )
	);
	$wp_customize->add_control(
	    'gym_club_slider_play_url',
	    array(
	        'type'    => 'url',
	        'label'   => __('Add URL', 'gym-club'),
	        'section' => 'gym_club_slider_section',
	    )
	);

	$wp_customize->add_setting('gym_club_btn_text1',array(
		'default'=> __('JOIN FREE 3 DAYS TRIAL','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_btn_text1',array(
		'label'	=> esc_html__('Change Slider Button Text','gym-club'),
		'section'=> 'gym_club_slider_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('gym_club_btn_link1',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('gym_club_btn_link1',array(
		'label'	=> esc_html__('Add Slider Button url','gym-club'),
		'section'=> 'gym_club_slider_section',
		'type'=> 'url'
	));
	
	/*=========================================
	service Section
	=========================================*/
	$wp_customize->add_section( 
		'gym_club_our_servs_section' , 
		array(
	        'title'      => __( 'Our Services Section', 'gym-club' ),
	        'priority' => 7,
	        'panel' => 'gym_club_panel_id',
    	) 
    );

    $wp_customize->add_setting( 'gym_club_our_servs_setting', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_our_servs_setting', array(
		'label'       => esc_html__( 'Show / Hide Section', 'gym-club' ),
		'section'     => 'gym_club_our_servs_section',
		'type'        => 'toggle',
		'settings'    => 'gym_club_our_servs_setting',
	) ) );

    $wp_customize->add_setting(
    	'gym_club_offer_section_tittle',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'gym_club_offer_section_tittle',
    	array(
	        'label' => __('Section Title','gym-club'),
	        'section'   => 'gym_club_our_servs_section',
	        'type'      => 'text'
    	)
    );

    $wp_customize->add_setting(
    	'gym_club_offer_section_text',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'gym_club_offer_section_text',
    	array(
	        'label' => __('Section Heading','gym-club'),
	        'section'   => 'gym_club_our_servs_section',
	        'type'      => 'text'
    	)
    );
   
	// Fetch all categories and populate the `$offer_cat` array.
	$categories = get_categories(array('hide_empty' => false)); 
	$offer_cat = array('select' => __('Select', 'gym-club')); 

	foreach ($categories as $category) {
	    $offer_cat[$category->slug] = $category->name;
	}

	// Add a setting for the category dropdown.
	$wp_customize->add_setting(
	    'gym_club_offer_section_category',
	    array(
	        'default'           => 'select', // Default to 'select'.
	        'sanitize_callback' => 'gym_club_sanitize_choices', // Use sanitization function.
	    )
	);
	// Add a control for the category dropdown.
	$wp_customize->add_control(
	    'gym_club_offer_section_category',
	    array(
	        'type'    => 'select',
	        'choices' => $offer_cat,
	        'label'   => __('Select Category', 'gym-club'),
	        'section' => 'gym_club_our_servs_section',
	    )
	);

   // Setting for number of posts to show
    $wp_customize->add_setting('gym_club_posts_to_show', array(
        'default'           => 4, // Default number of posts to show
        'sanitize_callback' => 'gym_club_sanitize_number_absint', // Sanitization callback
    ));
    // Add control for number of posts to show
    $wp_customize->add_control('gym_club_posts_to_show', array(
        'label'       => __('Number of Popular Posts to Show', 'gym-club'),
        'section'     => 'gym_club_our_servs_section',
        'priority'    => 10,
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 0,
            'max'  => 50,
        ),
    ));

    // Dynamic settings for Icons, Prices, and Features
    $gym_club_num_posts = get_theme_mod('gym_club_posts_to_show', 4);

    for ($gym_club_i = 1; $gym_club_i <= $gym_club_num_posts; $gym_club_i++) {

        $wp_customize->add_setting('gym_club_services_icon'.$gym_club_i,array(
			'default'	=> 'fas fa-heartbeat',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control(new Gym_Club_Icon_Changer(
	        $wp_customize,'gym_club_services_icon'.$gym_club_i,array(
			'label'	=> __('Change Service Icon ','gym-club').$gym_club_i,
			'transport' => 'refresh',
			'section'	=> 'gym_club_our_servs_section',
			'type'		=> 'icon'
		)));

    }

	//footer Widgets Section
	$wp_customize->add_section('gym_club_footer_section',array(
		'title'	=> __('Footer Widgets Settings','gym-club'),
		'description'	=> __('Add copyright text.','gym-club'),
		'panel' => 'gym_club_panel_id',
		'priority' => 7,
	));

	$wp_customize->add_setting('gym_club_footer_columns',array(
		'default'	=> 4,
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_footer_columns',array(
		'label'	=> __('Footer Widget Columns','gym-club'),
		'section'	=> 'gym_club_footer_section',
		'setting'	=> 'gym_club_footer_columns',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	));

	$wp_customize->add_setting( 'gym_club_tp_footer_bg_color_option', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_tp_footer_bg_color_option', array(
			'label'     => __('Footer Widget Background Color', 'gym-club'),
			'description' => __('It will change the complete footer widget backgorund color.', 'gym-club'),
			'section' => 'gym_club_footer_section',
			'settings' => 'gym_club_tp_footer_bg_color_option',
	)));

	$wp_customize->add_setting('gym_club_footer_widget_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'gym_club_footer_widget_image',array(
        'label' => __('Footer Widget Background Image','gym-club'),
         'section' => 'gym_club_footer_section'
	)));

	$wp_customize->add_setting('gym_club_footer_widget_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_footer_widget_title_font_size',array(
		'label'	=> __('Change Footer Widget Title Font Size in PX','gym-club'),
		'section'	=> 'gym_club_footer_section',
	    'setting'	=> 'gym_club_footer_widget_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'gym_club_footer_widget_title_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_footer_widget_title_color', array(
			'label'     => __('Change Footer Widget Title Color', 'gym-club'),
	    'section' => 'gym_club_footer_section',
	    'settings' => 'gym_club_footer_widget_title_color',
  	)));
  	
	$wp_customize->add_setting( 'gym_club_return_to_header', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_return_to_header', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'gym-club' ),
		'section'     => 'gym_club_footer_section',
		'type'        => 'toggle',
		'settings'    => 'gym_club_return_to_header',
	) ) );

    $wp_customize->add_setting('gym_club_scroll_top_icon',array(
	  'default'	=> 'fas fa-arrow-up',
	  'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Gym_Club_Icon_Changer(
	        $wp_customize,'gym_club_scroll_top_icon',array(
		'label'	=> __('Scroll to top Icon','gym-club'),
		'transport' => 'refresh',
		'section'	=> 'gym_club_footer_section',
			'type'		=> 'icon'
	)));

	$wp_customize->add_setting('gym_club_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'gym_club_sanitize_choices'
	));
	$wp_customize->add_control('gym_club_scroll_top_position',array(
        'type' => 'radio',
        'label'     => __('Scroll to top Position', 'gym-club'),
        'description'   => __('This option work for scroll to top', 'gym-club'),
       'section' => 'gym_club_footer_section',
       'choices' => array(
            'Right' => __('Right','gym-club'),
            'Left' => __('Left','gym-club'),
            'Center' => __('Center','gym-club')
     ),
	) );

	//footer Copyright
	$wp_customize->add_section('gym_club_footer_copyright_section',array(
		'title'	=> __('Footer Copyright Settings','gym-club'),
		'panel' => 'gym_club_panel_id',
		'priority' => 8,
	));

	$wp_customize->add_setting('gym_club_footer_text',array(
		'default'	=> __('Gym Club WordPress Theme By Themespride','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_footer_text',array(
		'label'	=> __('Copyright Text','gym-club'),
		'section'	=> 'gym_club_footer_copyright_section',
		'type'		=> 'text'
	));

	//footer widget title font size
	$wp_customize->add_setting('gym_club_footer_copyright_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_footer_copyright_font_size',array(
		'label'	=> __('Change Footer Copyright Font Size in PX','gym-club'),
		'section'	=> 'gym_club_footer_copyright_section',
	    'setting'	=> 'gym_club_footer_copyright_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'gym_club_footer_copyright_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_footer_copyright_text_color', array(
			'label'     => __('Change Footer Copyright Text Color', 'gym-club'),
	    'section' => 'gym_club_footer_copyright_section',
	    'settings' => 'gym_club_footer_copyright_text_color',
  	)));

  	$wp_customize->add_setting('gym_club_footer_copyright_top_bottom_padding',array(
		'default'	=> '',
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_footer_copyright_top_bottom_padding',array(
		'label'	=> __('Change Footer Copyright Padding in PX','gym-club'),
		'section'	=> 'gym_club_footer_copyright_section',
	    'setting'	=> 'gym_club_footer_copyright_top_bottom_padding',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'gym_club_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'gym_club_customize_partial_blogdescription',
	) );

	//Mobile Respnsive
	$wp_customize->add_section('gym_club_mobile_media_option',array(
		'title'         => __('Mobile Responsive media', 'gym-club'),
		'description' => __('Control will not function if the toggle in the main settings is off.', 'gym-club'),
		'priority' => 8,
		'panel' => 'gym_club_panel_id'
	) );

	$wp_customize->add_setting( 'gym_club_mobile_blog_description', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new gym_club_Toggle_Control( $wp_customize, 'gym_club_mobile_blog_description', array(
		'label'       => esc_html__( 'Show / Hide Blog Page Description', 'gym-club' ),
		'section'     => 'gym_club_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_mobile_blog_description',
	) ) );

	$wp_customize->add_setting( 'gym_club_return_to_header_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_return_to_header_mob', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'gym-club' ),
		'section'     => 'gym_club_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_return_to_header_mob',
	) ) );

	$wp_customize->add_setting( 'gym_club_related_post_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_related_post_mob', array(
		'label'       => esc_html__( 'Show / Hide Related Post', 'gym-club' ),
		'section'     => 'gym_club_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'gym_club_related_post_mob',
	) ) );

	//Site Identity
	$wp_customize->add_setting( 'gym_club_site_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_site_title', array(
		'label'       => esc_html__( 'Show / Hide Site Title', 'gym-club' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'gym_club_site_title',
	) ) );

	$wp_customize->add_setting('gym_club_site_title_font_size',array(
		'default'	=> 30,
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_site_title_font_size',array(
		'label'	=> __('Site Title Font Size in PX','gym-club'),
		'section'	=> 'title_tagline',
		'setting'	=> 'gym_club_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 80,
		),
	));

	$wp_customize->add_setting( 'gym_club_site_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_site_tagline_color', array(
			'label'     => __('Change Site Title Color', 'gym-club'),
	    'section' => 'title_tagline',
	    'settings' => 'gym_club_site_tagline_color',
  	)));

	$wp_customize->add_setting( 'gym_club_site_tagline', array(
	    'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_site_tagline', array(
		'label'       => esc_html__( 'Show / Hide Site Tagline', 'gym-club' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'gym_club_site_tagline',
	) ) );

	// logo site tagline size
	$wp_customize->add_setting('gym_club_site_tagline_font_size',array(
		'default'	=> 15,
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size in PX','gym-club'),
		'section'	=> 'title_tagline',
	    'setting'	=> 'gym_club_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'gym_club_logo_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_logo_tagline_color', array(
			'label'     => __('Change Site Tagline Color', 'gym-club'),
	    'section' => 'title_tagline',
	    'settings' => 'gym_club_logo_tagline_color',
  	)));
  	
    $wp_customize->add_setting('gym_club_logo_width',array(
		'default' => 50,
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_logo_width',array(
		'label'	=> esc_html__('Here You Can Customize Your Logo Size','gym-club'),
		'section'	=> 'title_tagline',
		'type'		=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 150,
		),
	));

	//Woo Coomerce
	$wp_customize->add_setting('gym_club_per_columns',array(
		'default'=> 3,
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_per_columns',array(
		'label'	=> __('Product Per Row','gym-club'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting('gym_club_product_per_page',array(
		'default'=> 9,
		'sanitize_callback'	=> 'gym_club_sanitize_number_absint'
	));
	$wp_customize->add_control('gym_club_product_per_page',array(
		'label'	=> __('Product Per Page','gym-club'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

   	$wp_customize->add_setting( 'gym_club_product_sidebar', array(
		 'default'           => true,
		 'transport'         => 'refresh',
		 'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Shop Page Sidebar', 'gym-club' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'gym_club_product_sidebar',
	) ) );

	$wp_customize->add_setting( 'gym_club_single_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_single_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Product Page Sidebar', 'gym-club' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'gym_club_single_product_sidebar',
	) ) );
	
	$wp_customize->add_setting( 'gym_club_related_product', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'gym_club_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Gym_Club_Toggle_Control( $wp_customize, 'gym_club_related_product', array(
		'label'       => esc_html__( 'Show / Hide related product', 'gym-club' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'gym_club_related_product',
	) ) );

	//add page template setting pannel
	$wp_customize->add_panel( 'gym_club_page_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Page Template Settings', 'gym-club' ),
	    'description' => __( 'Description of what this panel does.', 'gym-club' ),
	) );

	// 404 PAGE
	$wp_customize->add_section('gym_club_404_page_section',array(
		'title'         => __('404 Page', 'gym-club'),
		'description'   => 'Here you can customize 404 Page content.',
		'panel' => 'gym_club_page_panel_id'
	) );

	$wp_customize->add_setting('gym_club_edit_404_title',array(
		'default'=> __('Oops! That page cant be found.','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_club_edit_404_title',array(
		'label'	=> __('Edit Title','gym-club'),
		'section'=> 'gym_club_404_page_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('gym_club_edit_404_text',array(
		'default'=> __('It looks like nothing was found at this location. Maybe try a search?','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_edit_404_text',array(
		'label'	=> __('Edit Text','gym-club'),
		'section'=> 'gym_club_404_page_section',
		'type'=> 'text'
	));

	// Search Results
	$wp_customize->add_section('gym_club_no_result_section',array(
		'title'         => __('Search Results', 'gym-club'),
		'description'   => 'Here you can customize Search Result content.',
		'panel' => 'gym_club_page_panel_id'
	) );

	$wp_customize->add_setting('gym_club_edit_no_result_title',array(
		'default'=> __('Nothing Found','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('gym_club_edit_no_result_title',array(
		'label'	=> __('Edit Title','gym-club'),
		'section'=> 'gym_club_no_result_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('gym_club_edit_no_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','gym-club'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('gym_club_edit_no_result_text',array(
		'label'	=> __('Edit Text','gym-club'),
		'section'=> 'gym_club_no_result_section',
		'type'=> 'text'
	));

	// Header Image Height
    $wp_customize->add_setting(
        'gym_club_header_image_height',
        array(
            'default'           => 400,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'gym_club_header_image_height',
        array(
            'label'       => esc_html__( 'Header Image Height', 'gym-club' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the height of the header image. Default is 350px.', 'gym-club' ),
            'input_attrs' => array(
                'min'  => 220,
                'max'  => 1000,
                'step' => 1,
            ),
        )
    );

    // Header Background Position
    $wp_customize->add_setting(
        'gym_club_header_background_position',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'gym_club_header_background_position',
        array(
            'label'       => esc_html__( 'Header Background Position', 'gym-club' ),
            'section'     => 'header_image',
            'type'        => 'select',
            'choices'     => array(
                'top'    => esc_html__( 'Top', 'gym-club' ),
                'center' => esc_html__( 'Center', 'gym-club' ),
                'bottom' => esc_html__( 'Bottom', 'gym-club' ),
            ),
            'description' => esc_html__( 'Choose how you want to position the header image.', 'gym-club' ),
        )
    );

    // Header Image Parallax Effect
    $wp_customize->add_setting(
        'gym_club_header_background_attachment',
        array(
            'default'           => 1,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'gym_club_header_background_attachment',
        array(
            'label'       => esc_html__( 'Header Image Parallax', 'gym-club' ),
            'section'     => 'header_image',
            'type'        => 'checkbox',
            'description' => esc_html__( 'Add a parallax effect on page scroll.', 'gym-club' ),
        )
    );

    //Opacity
	$wp_customize->add_setting('gym_club_header_banner_opacity_color',array(
       'default'              => '0.5',
       'sanitize_callback' => 'gym_club_sanitize_choices'
	));
    $wp_customize->add_control( 'gym_club_header_banner_opacity_color', array(
		'label'       => esc_html__( 'Header Image Opacity','gym-club' ),
		'section'     => 'header_image',
		'type'        => 'select',
		'settings'    => 'gym_club_header_banner_opacity_color',
		'choices' => array(
           '0' =>  esc_attr(__('0','gym-club')),
           '0.1' =>  esc_attr(__('0.1','gym-club')),
           '0.2' =>  esc_attr(__('0.2','gym-club')),
           '0.3' =>  esc_attr(__('0.3','gym-club')),
           '0.4' =>  esc_attr(__('0.4','gym-club')),
           '0.5' =>  esc_attr(__('0.5','gym-club')),
           '0.6' =>  esc_attr(__('0.6','gym-club')),
           '0.7' =>  esc_attr(__('0.7','gym-club')),
           '0.8' =>  esc_attr(__('0.8','gym-club')),
           '0.9' =>  esc_attr(__('0.9','gym-club'))
		), 
	) );

   $wp_customize->add_setting( 'gym_club_header_banner_image_overlay', array(
	    'default'   => true,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'gym_club_sanitize_checkbox',
	));
	$wp_customize->add_control( new gym_club_Toggle_Control( $wp_customize, 'gym_club_header_banner_image_overlay', array(
	    'label'   => esc_html__( 'Show / Hide Header Image Overlay', 'gym-club' ),
	    'section' => 'header_image',
	)));

    $wp_customize->add_setting('gym_club_header_banner_image_ooverlay_color', array(
		'default'           => '#C5FF00',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'gym_club_header_banner_image_ooverlay_color', array(
		'label'    => __('Header Image Overlay Color', 'gym-club'),
		'section'  => 'header_image',
	)));

    $wp_customize->add_setting(
        'gym_club_header_image_title_font_size',
        array(
            'default'           => 32,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'gym_club_header_image_title_font_size',
        array(
            'label'       => esc_html__( 'Change Header Image Title Font Size', 'gym-club' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the font Size of the header image title. Default is 32px.', 'gym-club' ),
            'input_attrs' => array(
                'min'  => 10,
                'max'  => 200,
                'step' => 1,
            ),
        )
    );

	$wp_customize->add_setting( 'gym_club_header_image_title_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gym_club_header_image_title_text_color', array(
			'label'     => __('Change Header Image Title Color', 'gym-club'),
	    'section' => 'header_image',
	    'settings' => 'gym_club_header_image_title_text_color',
  	)));

}
add_action( 'customize_register', 'gym_club_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since Gym Club 1.0
 * @see gym_club_customize_register()
 *
 * @return void
 */
function gym_club_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since Gym Club 1.0
 * @see gym_club_customize_register()
 *
 * @return void
 */
function gym_club_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if ( ! defined( 'GYM_CLUB_PRO_THEME_NAME' ) ) {
	define( 'GYM_CLUB_PRO_THEME_NAME', esc_html__( 'Gym Club Pro', 'gym-club' ));
}
if ( ! defined( 'GYM_CLUB_PRO_THEME_URL' ) ) {
	define( 'GYM_CLUB_PRO_THEME_URL', esc_url('https://www.themespride.com/products/gym-club-wordpress-theme'));
}
if ( ! defined( 'GYM_CLUB_DOCS_URL' ) ) {
	define( 'GYM_CLUB_DOCS_URL', esc_url('https://page.themespride.com/demo/docs/gym-club-lite/'));
}

if ( ! defined( 'GYM_CLUB_DEMO_TITLE' ) ) {
	define( 'GYM_CLUB_DEMO_TITLE', esc_html__( 'Click to View Site', 'gym-club' ));
}
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Gym_Club_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Gym_Club_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Gym_Club_Customize_Section_Pro(
				$manager,
				'gym_club_section_pro',
				array(
					'priority'   => 9,
					'title'    => GYM_CLUB_PRO_THEME_NAME,
					'pro_text' => esc_html__( 'Upgrade Pro', 'gym-club' ),
					'pro_url'  => esc_url( GYM_CLUB_PRO_THEME_URL, 'gym-club' ),
				)
			)
		);

		// Register sections.
		$manager->add_section(
			new gym_club_Customize_Section_Pro(
				$manager,
				'gym_club_documentation',
				array(
					'priority'   => 500,
					'title'    => esc_html__( 'Theme Documentation', 'gym-club' ),
					'pro_text' => esc_html__( 'Click Here', 'gym-club' ),
					'pro_url'  => esc_url( GYM_CLUB_DOCS_URL, 'gym-club'),
				)
			)
		);

		// Register sections.
		$manager->add_section(
			new gym_club_Customize_Section_Pro(
				$manager,
				'gym_club_section_pro_demo',
				array(
					'priority'   => 9,
					'title'    => GYM_CLUB_DEMO_TITLE,
					'pro_text' => esc_html__( 'View Site', 'gym-club' ),
					'pro_url'  => esc_url( home_url() ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'gym-club-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'gym-club-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Gym_Club_Customize::get_instance();