<?php
/**
 * Custom header implementation
 *
 * @link https://codex.wordpress.org/Custom_Headers
 *
 * @package Gym Club
 * @subpackage gym_club
 */

function gym_club_custom_header_setup() {
    register_default_headers( array(
        'default-image' => array(
            'url'           => get_template_directory_uri() . '/assets/images/header_img.png',
            'thumbnail_url' => get_template_directory_uri() . '/assets/images/header_img.png',
            'description'   => __( 'Default Header Image', 'gym-club' ),
        ),
    ) );
}
add_action( 'after_setup_theme', 'gym_club_custom_header_setup' );

/**
 * Styles the header image based on Customizer settings.
 */
function gym_club_header_style() {
    $gym_club_header_image = get_header_image() ? get_header_image() : get_template_directory_uri() . '/assets/images/header_img.png';

    $gym_club_height     = get_theme_mod( 'gym_club_header_image_height', 350 );
    $gym_club_position   = get_theme_mod( 'gym_club_header_background_position', 'center' );
    $gym_club_attachment = get_theme_mod( 'gym_club_header_background_attachment', 1 ) ? 'fixed' : 'scroll';

    $gym_club_custom_css = "
        .header-img, .single-page-img, .external-div .box-image-page img, .external-div {
            background-image: url('" . esc_url( $gym_club_header_image ) . "');
            background-size: cover;
            height: " . esc_attr( $gym_club_height ) . "px;
            background-position: " . esc_attr( $gym_club_position ) . ";
            background-attachment: " . esc_attr( $gym_club_attachment ) . ";
        }

        @media (max-width: 1000px) {
             .header-img, .single-page-img, .external-div .box-image-page img,.external-div,.featured-image{
                height: 250px !important;
            }
            .box-text h2{
                font-size: 27px;
            }
        }
    ";

    wp_add_inline_style( 'gym-club-style', $gym_club_custom_css );
}
add_action( 'wp_enqueue_scripts', 'gym_club_header_style' );

/**
 * Enqueue the main theme stylesheet.
 */
function gym_club_enqueue_styles() {
    wp_enqueue_style( 'gym-club-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'gym_club_enqueue_styles' );