( function( window, document ) {
  function gym_club_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const gym_club_nav = document.querySelector( '.sidenav' );
      if ( ! gym_club_nav || ! gym_club_nav.classList.contains( 'open' ) ) {
        return;
      }
      const elements = [...gym_club_nav.querySelectorAll( 'input, a, button' )],
        gym_club_lastEl = elements[ elements.length - 1 ],
        gym_club_firstEl = elements[0],
        gym_club_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;
      if ( ! shiftKey && tabKey && gym_club_lastEl === gym_club_activeEl ) {
        e.preventDefault();
        gym_club_firstEl.focus();
      }
      if ( shiftKey && tabKey && gym_club_firstEl === gym_club_activeEl ) {
        e.preventDefault();
        gym_club_lastEl.focus();
      }
    } );
  }
  gym_club_keepFocusInMenu();
} )( window, document );