<?php
/**
 * Block Filters
 *
 * @package fse_sports_arena
 * @since 1.0
 */

function fse_sports_arena_block_wrapper( $fse_sports_arena_block_content, $fse_sports_arena_block ) {

	if ( 'core/button' === $fse_sports_arena_block['blockName'] ) {
		
		if( isset( $fse_sports_arena_block['attrs']['className'] ) && strpos( $fse_sports_arena_block['attrs']['className'], 'has-arrow' ) ) {
			$fse_sports_arena_block_content = str_replace( '</a>', fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'caret-circle-right' ) ) ) . '</a>', $fse_sports_arena_block_content );
			return $fse_sports_arena_block_content;
		}
	}

	if( ! is_single() ) {
	
		if ( 'core/post-terms'  === $fse_sports_arena_block['blockName'] ) {
			if( 'post_tag' === $fse_sports_arena_block['attrs']['term'] ) {
				$fse_sports_arena_block_content = str_replace( '<div class="taxonomy-post_tag wp-block-post-terms">', '<div class="taxonomy-post_tag wp-block-post-terms flex">' . fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'tags' ) ) ), $fse_sports_arena_block_content );
			}

			if( 'category' ===  $fse_sports_arena_block['attrs']['term'] ) {
				$fse_sports_arena_block_content = str_replace( '<div class="taxonomy-category wp-block-post-terms">', '<div class="taxonomy-category wp-block-post-terms flex">' . fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'category' ) ) ), $fse_sports_arena_block_content );
			}
			return $fse_sports_arena_block_content;
		}
		if ( 'core/post-date' === $fse_sports_arena_block['blockName'] ) {
			$fse_sports_arena_block_content = str_replace( '<div class="wp-block-post-date">', '<div class="wp-block-post-date flex">' . fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'calendar' ) ) ), $fse_sports_arena_block_content );
			return $fse_sports_arena_block_content;
		}
		if ( 'core/post-author' === $fse_sports_arena_block['blockName'] ) {
			$fse_sports_arena_block_content = str_replace( '<div class="wp-block-post-author">', '<div class="wp-block-post-author flex">' . fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'user' ) ) ), $fse_sports_arena_block_content );
			return $fse_sports_arena_block_content;
		}
	}
	if( is_single() ){

		// Add chevron icon to the navigations
		if ( 'core/post-navigation-link' === $fse_sports_arena_block['blockName'] ) {
			if( isset( $fse_sports_arena_block['attrs']['type'] ) && 'previous' === $fse_sports_arena_block['attrs']['type'] ) {
				$fse_sports_arena_block_content = str_replace( '<span class="post-navigation-link__label">', '<span class="post-navigation-link__label">' . fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'prev' ) ) ), $fse_sports_arena_block_content );
			}
			else {
				$fse_sports_arena_block_content = str_replace( '<span class="post-navigation-link__label">Next Post', '<span class="post-navigation-link__label">Next Post' . fse_sports_arena_get_svg( array( 'icon' => esc_attr( 'next' ) ) ), $fse_sports_arena_block_content );
			}
			return $fse_sports_arena_block_content;
		}
		if ( 'core/post-date' === $fse_sports_arena_block['blockName'] ) {
            $fse_sports_arena_block_content = str_replace( '<div class="wp-block-post-date">', '<div class="wp-block-post-date flex">' . fse_sports_arena_get_svg( array( 'icon' => 'calendar' ) ), $fse_sports_arena_block_content );
            return $fse_sports_arena_block_content;
        }
		if ( 'core/post-author' === $fse_sports_arena_block['blockName'] ) {
            $fse_sports_arena_block_content = str_replace( '<div class="wp-block-post-author">', '<div class="wp-block-post-author flex">' . fse_sports_arena_get_svg( array( 'icon' => 'user' ) ), $fse_sports_arena_block_content );
            return $fse_sports_arena_block_content;
        }

	}
    return $fse_sports_arena_block_content;
}
	
add_filter( 'render_block', 'fse_sports_arena_block_wrapper', 10, 2 );
